<?php

namespace App\Http\Controllers;

use App\CategoryTips;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Input;
use Session;
use Redirect;

class CategoryTipsController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth');
    }
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $categories = CategoryTips::all();
        return view('category_tips.index', compact('categories'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return view('category_tips.create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $validation = $request->validate([
            'name' => 'required',
            'image' => 'required'
        ]);

        if(Input::hasFile('image')) {
            $this->validate($request, ['image' => 'mimes:jpeg,jpg,png',]);

            $file_logo = Input::file('image');
            $ext = $file_logo->getClientOriginalExtension();
            $fileLogo = time() . "_" . "categories" . "." . $ext;

            $category = new CategoryTips();
            $category->name = $request['name'];
            $category->image = 'images/categories/'.$fileLogo;
            $category->save();

            $folder = public_path().'/images/categories';
            if(!file_exists($folder)){
                mkdir($folder, 0777, true);
                $file_logo->move(public_path().'/images/categories/',$fileLogo);
            }else{
                $file_logo->move(public_path().'/images/categories/',$fileLogo);
            }

            Session::flash('message', 'Categoría creada correctamente.');
            return Redirect::to('/categories-tips');
        }else{
            Session::flash('message', 'Ocurrió un error al crear la categoría.');
            return Redirect::to('/categories-tips');
        }
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\CategoryTips  $categoryTips
     * @return \Illuminate\Http\Response
     */
    public function show(CategoryTips $categoryTips)
    {
        return view('category_tips.create');
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\CategoryTips  $categoryTips
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $category = CategoryTips::find($id);
        return view('category_tips.edit', compact('category'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\CategoryTips  $categoryTips
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request,$id)
    {
        $validation = $request->validate([
            'name' => 'required'
        ]);

        $category = CategoryTips::find($id);

        if(Input::hasFile('image')){
            $file_logo = Input::file('image');
            $ext = $file_logo->getClientOriginalExtension();
            $fileLogo = time() . "_" . "categories" . "." . $ext;

            // Erase image if exists
            $image_path = $category->image;
            if($image_path != '') {
                if (file_exists(public_path() . '/' . $image_path)) {
                    unlink(public_path() . '/' . $image_path);
                }
            }
            $file_logo->move(public_path().'/images/categories/',$fileLogo);
            $category->image = 'images/categories/'.$fileLogo;
        }

        $category->name = $request['name'];
        $category->save();

        Session::flash('message','Categoría actualizada');
        return Redirect::to('/categories-tips');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\CategoryTips  $categoryTips
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $category = CategoryTips::find($id);
        $fileLogo = $category->image;

       if(file_exists(public_path().'/'.$fileLogo))
            unlink(public_path().'/'.$fileLogo);

        CategoryTips::destroy($id);
        Session::flash('message', 'Categoría eliminada correctamente.');
    }

    public function test($id){
        echo $id;
    }
}
