@extends("layouts.master")
@section("styles")
    {!! Html::style("/assets/css/main.css") !!}
    {!! Html::style("/assets/global/plugins/bootstrap-fileinput/bootstrap-fileinput.css") !!}
    {!! Html::style("/assets/global/plugins/bootstrap-wysihtml5/bootstrap-wysihtml5.css") !!}
@endsection

@section('breadcrumb')
    <div class="page-bar">
        @include('partials.request')
        <ul class="page-breadcrumb">
            <li>
                <a href="{!!URL::to('/')!!}">Inicio</a>
                <i class="fa fa-circle"></i>
            </li>
            <li>
                <a href="{!!URL::to('/categories-tips')!!}">Categorias</a>
                <i class="fa fa-circle"></i>
            </li>
            <li>
                <a>Editar categoría</a>
            </li>
        </ul>
    </div>
@endsection

@section("page-content")
    <div class="row content_container">
        <div class="col-md-12">
            <!-- BEGIN EXAMPLE TABLE PORTLET-->
            <div class="portlet light portlet-fit bordered">
                <div class="portlet-title">
                    <div class="caption">
                        <span class="caption-subject bold">Editar categoría</span>
                    </div>
                </div>
                <div class="portlet-body" style="padding-bottom: 60px;">
                    {!! Form::model($category,['route' => ['categories-tips.update', $category->id], 'method' => 'PUT', 'files' => true]) !!}
                    @include("category_tips.form")
                    {!!Form::close()!!}
                </div>
            </div>
            <!-- END EXAMPLE TABLE PORTLET-->
        </div>
    </div>
@endsection

@section("scripts")
    {!! Html::script("/assets/scripts/validateFields.js") !!}
    {!! Html::script("/assets/global/plugins/bootstrap-fileinput/bootstrap-fileinput.js") !!}
    {!! Html::script("/assets/global/plugins/bootstrap-wysihtml5/wysihtml5-0.3.0.js") !!}
    {!! Html::script("/assets/global/plugins/bootstrap-wysihtml5/bootstrap-wysihtml5.js") !!}
    {!! Html::script("/assets/pages/scripts/components-editors.min.js") !!}

    <script type="application/javascript">
        $(document).ready(function(){
            $("#liTips").addClass("active");
        });
    </script>
@endsection
