@extends("layouts.master")

@section("styles")
  {!!Html::style("/assets/global/plugins/datatables/datatables.min.css")!!}
  {!! Html::style("/assets/css/main.css") !!}
@endsection

@section('breadcrumb')
  @include('partials.message')
  <div class="page-bar">
    <ul class="page-breadcrumb">
      <li>
        <a href="{!!URL::to('/')!!}">Inicio</a>
        <i class="fa fa-circle"></i>
      </li>
      <li>
        <a href="{!!URL::to('/services')!!}">Servicios</a>
      </li>
    </ul>
  </div>
@endsection

@section("page-content")
  <div class="row content_container">
    <div class="col-md-12">
      <!-- BEGIN EXAMPLE TABLE PORTLET-->
      <div class="portlet light portlet-fit bordered">
        <div class="portlet-title">
          <div class="row">
            <div class="col-md-6"> <span class="caption-subject bold" style="font-size: 16px; color:gray">Servicios</span></div>
            <div class="col-md-6">
              {{--<div class="btn-group pull-right">
                <a href="{{URL::route('banners.create')}}" class="btn green"><i class="fa fa-plus"></i> Nuevo Banner </a>
              </div>--}}
            </div>
          </div>
        </div>
        <div class="portlet-body">
          <table class="table table-striped table-hover table-bordered" id="sample_editable_1">
            <thead>
            <tr>
              <th class="center">Nombre</th>
              <th class="center">Imagen</th>
              <th class="center">Acciones</th>
            </tr>
            </thead>

            <tbody>
            @foreach($services as $service)
              <tr>
                <td class="center"> {{$service->name}} </td>
                <td class="center"><img src="{{$service->image}}" alt="banner" height="75"/></td>
                <td>
                  <a href="{{  URL::route('services.edit', $service->id) }}" title="Editar" class="btn btn-icon-only green-meadow ">
                    <i class="fa fa-edit"></i>
                  </a>
                </td>
              </tr>
            @endforeach
            </tbody>
          </table>
        </div>
      </div>
      <!-- END EXAMPLE TABLE PORTLET-->
    </div>
  </div>
@endsection

@section("scripts")
  {!! Html::script("/assets/global/scripts/datatable.js") !!}
  {!! Html::script("/assets/global/plugins/datatables/datatables.min.js") !!}
  {!! Html::script("/assets/global/plugins/datatables/plugins/bootstrap/datatables.bootstrap.js") !!}
  {!! Html::script("/assets/scripts/simplified_datatable.js") !!}
  <script type="application/javascript">
    $(document).ready(function(){
      $("#liSer").addClass("active");
    });
  </script>
@endsection
