@extends("layouts.master")

@section("styles")
  {!!Html::style("/assets/global/plugins/datatables/datatables.min.css")!!}
  {!! Html::style("/assets/css/main.css") !!}
@endsection

@section('breadcrumb')
  @include('partials.message')
  <div class="page-bar">
    <ul class="page-breadcrumb">
      <li>
        <a href="{!!URL::to('/')!!}">Inicio</a>
        <i class="fa fa-circle"></i>
      </li>
      <li>
        <a href="{!!URL::to('/tips')!!}">Tips de Viaje</a>
        <i class="fa fa-circle"></i>
      </li>
   {{--   <li>
        <a href="{{ URL::route('tips', ['continent' => $continent->id]) }}">Tips de Viaje</a>
      </li>--}}
    </ul>
  </div>
@endsection

@section("page-content")
  <div class="row content_container">
    <div class="col-md-12">
      <!-- BEGIN EXAMPLE TABLE PORTLET-->
      <div class="portlet light portlet-fit bordered">
        <div class="portlet-title">
          <div class="row">
            <div class="col-md-6"> <span class="caption-subject bold" style="font-size: 16px; color:gray"> Tips</span></div>
            <div class="col-md-6">
              <div class="btn-group pull-right">
                <a href="{{URL::route('tips.create')}}" class="btn green"><i class="fa fa-plus"></i> Nuevo Tip </a>
              </div>
            </div>
          </div>
        </div>
        <div class="portlet-body">
          <table class="table table-striped table-hover table-bordered" id="sample_editable_1">
            <thead>
            <tr>
              <th class="center">Imagen</th>
              <th class="center">Titulo</th>
             {{-- <th class="center">Subtitulo</th>--}}
              <th class="center">Descripción</th>
              <th class="center">Acciones</th>
            </tr>
            </thead>

            <tbody>
            @foreach($tips as $tip)
              <tr>
                <td class="center"><img src="/{{$tip->image}}" alt="banner" height="75"/></td>
                <td class="center"> {{$tip->title}} </td>
               {{-- <td class="center"> {{$tip->subtitle}} </td>--}}
                <td class="center"> {{$tip->description}} </td>
                <td>
                  <a href="{{ URL::route('tips.edit', ['tip'=> $tip->id]) }}" title="Editar" class="btn btn-icon-only green-meadow ">
                    <i class="fa fa-edit"></i>
                  </a>
                  <a href="#basic" data-toggle="modal" data-name="{{$tip->title}}" data-id="{{$tip->id}}" title="Eliminar" class="btn btn-icon-only red modalDelete">
                    <i class="fa fa-times"></i>
                  </a>
                </td>
              </tr>
            @endforeach
            </tbody>
          </table>
        </div>
      </div>
      <!-- END EXAMPLE TABLE PORTLET-->
    </div>
  </div>

  <div class="modal fade" id="basic" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true">
    <div class="modal-dialog">
      <div class="modal-content">
        <div class="modal-header">
          <h4 class="modal-title">Eliminar tip</h4>
        </div>
        <div class="modal-body" id="bodyDelete">
        </div>
        <div class="modal-footer">
          <input type="hidden" name="_token" value="{{csrf_token()}}" id="token">
          <button type="button" class="btn green-meadow" data-dismiss="modal" onclick="deleteUser()">Aceptar</button>
          <button type="button" class="btn red " data-dismiss="modal"></i>Cancelar</button>
        </div>
      </div>
      <!-- /.modal-content -->
    </div>
    <!-- /.modal-dialog -->
  </div>
  <!-- /.modal -->
@endsection

@section("scripts")
  {!! Html::script("/assets/global/scripts/datatable.js") !!}
  {!! Html::script("/assets/global/plugins/datatables/datatables.min.js") !!}
  {!! Html::script("/assets/global/plugins/datatables/plugins/bootstrap/datatables.bootstrap.js") !!}
  {!! Html::script("/assets/scripts/simplified_datatable.js") !!}
  <script type="application/javascript">
    $(document).ready(function(){
      $("#liTips").addClass("active");
    });

    $(".modalDelete").click(function(){
      id = $(this).data("id");
      var name = $(this).data("name");

      var nodeName=document.createElement("p");
      var nameNode=document.createTextNode("¿Seguro que desea eliminar el tip?" );
      nodeName.appendChild(nameNode);
      $("#bodyDelete").empty();
      document.getElementById("bodyDelete").appendChild(nodeName);
    });

    function deleteUser(){
      var token = $("#token").val();

      $.ajax({
        url: "tips/"+id,
        headers: {'X-CSRF-TOKEN': token},
        type: "DELETE",
        success: function() {
          window.location = "/tips";
          $("#message").fadeIn();
        }
      });
    }
  </script>
@endsection
